/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.food;

import com.renyigesai.immortalers_delight.api.PlateBaseBlock;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class ZeaPancakeBLock
extends HorizontalDirectionalBlock
implements PlateBaseBlock {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)4);
    public static final VoxelShape BOX = ZeaPancakeBLock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);

    public ZeaPancakeBLock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        super.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return BOX;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack hand_stack = player.m_21120_(hand);
        if (hand_stack.m_204117_(ModTags.KNIVES)) {
            return this.cut(state, level, pos, player);
        }
        if (!hand_stack.m_204117_(ModTags.KNIVES)) {
            return this.eat(state, level, pos, player);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult eat(BlockState state, Level level, BlockPos pos, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < 4) {
            if (!player.m_36391_(false)) return InteractionResult.PASS;
            this.setBlock(bites, state, level, pos);
            player.m_36324_().m_38712_((Item)ImmortalersDelightItems.ZEA_PANCAKE_SLICE.get(), new ItemStack((ItemLike)ImmortalersDelightItems.ZEA_PANCAKE_SLICE.get()));
            level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
            return InteractionResult.SUCCESS;
        } else {
            level.m_46961_(pos, false);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42399_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.0, (double)0.0);
            level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult cut(BlockState state, Level level, BlockPos pos, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        Direction direction = player.m_6350_().m_122424_();
        if (bites < 4) {
            this.setBlock(bites, state, level, pos);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)ImmortalersDelightItems.ZEA_PANCAKE_SLICE.get()), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        } else {
            level.m_7471_(pos, false);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)new ItemStack((ItemLike)Items.f_42399_), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        }
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void setBlock(int variate, BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(variate + 1)), 3);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES, f_54117_});
    }

    @Override
    public boolean isEmptyPlate(BlockState state) {
        return (Integer)state.m_61143_((Property)BITES) == 4;
    }
}

